
#ifndef SST_EXT_ATP_AUTHENTICATORS_H
#define SST_EXT_ATP_AUTHENTICATORS_H

#include "SST_Ext_DEFINES.h"

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_Ext_ATP_Authenticators.h#1:incl:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Structs  ******************************/
/*Authenticator test struct*/
typedef struct EXT_ATP_PassAuthTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_MasterPassword[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_MasterPasswordSizeInBytes;
    DxUint32_t                  TST_MasterMaxNumOfTrials;
    DxByte_t                    TST_SecondaryPassword[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_SecondaryPasswordSizeInBytes;
    DxUint32_t                  TST_SecondaryMaxNumOfTrials;
    DxByte_t                    TST_NewSecPassword[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_NewSecPasswordSizeInBytes;
    DxUint32_t                  TST_NewSecMaxNumOfTrials;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} SEP_ATP_PassAuthTestDataStruct;



typedef struct EXT_ATP_RsaAuthTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_N[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_NSizeInBytes;
    DxByte_t                    TST_D[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_DSizeInBytes;
    DxByte_t                    TST_E[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_ESizeInBytes;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_NewChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_NewChallengeBuffSize;  
    DxByte_t                    TST_SignedChallengeBuff[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_SignedChallengeBuffSize;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} EXT_ATP_RsaAuthTestDataStruct;

#if TST_USE_AUTHENTICATOR_MODULE
typedef struct EXT_ATP_AesKeyAuthTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_AesKey[TST_AES_KEY_SIZE];
    DxUint32_t                  TST_KeySizeInBytes;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_NewChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_NewChallengeBuffSize; 
    DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_EncChallengeBuffSize;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} EXT_ATP_AesKeyAuthTestDataStruct;


typedef struct EXT_ATP_ECCAuthTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKeySize;
    DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKeySize;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_NewChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_NewChallengeBuffSize;  
    DxByte_t                    TST_SignedChallengeBuff[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_SignedChallengeBuffSize;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} EXT_ATP_ECCAuthTestDataStruct;

/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_PasswordAuthenticator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, 
 * closing and usage of a password authenticator object. 
 * And demonstrate the use of transaction with authenticator objects
 *  
 * Algorithm:       
 *    1.Call to HOSTQA_ATP_Message function
 *                                
 *******************************************************************************/    
DxError_t SST_Ext_ATP_PasswordAuthenticator (void);
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_RsaAsymAuthenticator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of an asymmetric key authenticator object.
 * And demonstration on the use of transaction with authenticator objects.
 *  
 * Algorithm:       
 *    1.Call to HOSTQA_ATP_Message function                         
 *
 *******************************************************************************/    
DxError_t SST_Ext_ATP_RsaAsymAuthenticator (void);
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_AesKeyAsymAuthenticator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of a shared key authenticator object.
 * And demonstration on the use of transaction with authenticator objects
 *  
 * Algorithm:       
 *   1.Call to HOSTQA_ATP_Message function
 * 
 *******************************************************************************/    
DxError_t SST_Ext_ATP_AesKeyAsymAuthenticator (void);

/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_ECCAsymAuthenticator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of an ECC asymmetric key authenticator object.
 * And demonstration on the use of transaction with authenticator objects.
 *  
 * Algorithm:       
 *   1.Call to HOSTQA_ATP_Message function
 * 
 *******************************************************************************/   
 DxError_t SST_Ext_ATP_ECCAsymAuthenticator (void);


#ifdef __cplusplus
}
#endif

#endif

#endif

